<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'd_o_b', 'pin_code', 'last_donation_date');

    public function BloodType()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Models\Post');
    }

    public function donation_request()
    {
        return $this->hasOne('App\Models\DonationRequests');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact');
    }

    public function tokens()
    {
        return $this->hasMany('App\Models\Token');
    }

    public function bloodTypes()
    {
        return $this->belongsToMany('App\Models\BloodType');
    }

}